/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.pa.ar;

import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.incident.IncidentPool;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.domain.GlobalSurveillanceAnalysisDomain;
import com.ibm.hwmca.p.pa.event.GlobalSurveillanceDomainAnalysisEvent;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.pa.problem.SupportingSurveillanceInfo;
import com.ibm.hwmca.xfw.pa.ar.AnalysisDomainAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.incident.CommonServiceIncident;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import com.ibm.hwmca.xfw.pa.system.RemotePartitionSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class GlobalSurveillanceDomainAnalysisRoutine
extends AnalysisDomainAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPAGSART";
    private static final String TRACE_MASKF = "PPAGSARF";
    private static final String TRACE_MASKD = "PPAGSARD";
    private static final String GSAD_DDID_SEPARATOR = "//";

    public GlobalSurveillanceDomainAnalysisRoutine() {
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent event) {
        Trace.trace(TRACE_MASKD, "--> GlobalSurveillanceDomain.analyze() 07/30/04 15:49");
        GlobalSurveillanceDomainAnalysisEvent ourEvent = (GlobalSurveillanceDomainAnalysisEvent)event;
        String refcode = null;
        IncidentPool gsadPool = CommonServiceAnalysisRoutine.getAnalyzingIncidentPool(ourEvent.getIncidentPoolId());
        Trace.trace(TRACE_MASKD, "GSAD pool size = " + gsadPool.size());
        if (gsadPool.size() > 0) {
            CommonProblem cp;
            GlobalSurveillanceAnalysisDomain gsad = (GlobalSurveillanceAnalysisDomain)DomainManager.getDomainManager().get(GlobalSurveillanceAnalysisDomain.GSAD_DOMAINID);
            Set aCons = gsad.getActiveConsoles();
            Set iaCons = gsad.getInactiveConsoles();
            Set aRemotes = gsad.getActiveRemoteMachines();
            Set iaRemotes = gsad.getMonitoredRemoteMachineSystems();
            Trace.trace(TRACE_MASKD, "activeConsoles.size()=" + aCons.size());
            Trace.trace(TRACE_MASKD, "inactiveConsoles.size()=" + iaCons.size());
            Trace.trace(TRACE_MASKD, "activeRemotes.size()=" + aRemotes.size());
            Trace.trace(TRACE_MASKD, "inactiveConsoles.size()=" + iaRemotes.size());
            if (iaCons.size() > 0) {
                // empty if block
            }
            HashMap hmcsAnalysis = new HashMap();
            Trace.trace(TRACE_MASKD, "This Domain is considered primary do Analysis Here");
            Iterator gsadapI = gsadPool.iterator();
            while (gsadapI.hasNext()) {
                CommonServiceIncident csi = (CommonServiceIncident)gsadapI.next();
                cp = csi.getProblem();
                Trace.trace(TRACE_MASKD, "problem from pool " + cp.getPrimaryAnalyzingConsoleSystem().getMTMS());
                if (hmcsAnalysis.containsKey(cp.getPrimaryAnalyzingConsoleSystem().getMTMS())) {
                    HashMap consoleProblems = (HashMap)hmcsAnalysis.get(cp.getPrimaryAnalyzingConsoleSystem().getMTMS());
                    if (consoleProblems.containsKey(cp.getFailingSystem().getMTMS())) continue;
                    consoleProblems.put(cp.getFailingSystem().getMTMS(), cp.getFailingSystem());
                    continue;
                }
                HashMap<String, PASystem> thisFailingSystemMap = new HashMap<String, PASystem>();
                thisFailingSystemMap.put(cp.getFailingSystem().getMTMS(), cp.getFailingSystem());
                hmcsAnalysis.put(cp.getPrimaryAnalyzingConsoleSystem().getMTMS(), thisFailingSystemMap);
            }
            if (hmcsAnalysis.size() > 1) {
                Trace.trace(TRACE_MASKD, "mulitple hmcs with failures");
                HashMap gFailings = this.getFailingSystems(hmcsAnalysis);
                if (gFailings.size() == 1) {
                    Trace.trace(TRACE_MASKD, "mulitple hmcs with failures to single systems");
                }
                PIFru symFru = new PIFru();
                symFru.setFruClass(12);
                String FRU_PARTNUMBER = new String();
                String FRU_LOCATION_SUFFIX = new String();
                if (gFailings.size() > 1) {
                    Trace.trace(TRACE_MASKD, "mulitple hmcs with failures to multiple systems");
                    int countOfCecs = 0;
                    int countOfPartitions = 0;
                    int countOfConsoles = 0;
                    Iterator gfI = gFailings.keySet().iterator();
                    while (gfI.hasNext()) {
                        PASystem fs = (PASystem)gFailings.get(gfI.next());
                        if (fs instanceof RemoteMachineSystem) {
                            ++countOfCecs;
                        }
                        if (fs instanceof RemoteConsoleSystem) {
                            ++countOfConsoles;
                        }
                        if (!(fs instanceof RemotePartitionSystem)) continue;
                        ++countOfPartitions;
                    }
                    if (gFailings.size() == countOfCecs) {
                        Trace.trace(TRACE_MASKD, "mulitple hmcs with failures to multiple Squadrons systems");
                        refcode = "B3030006";
                        FRU_PARTNUMBER = "HMCMULTNTWK";
                        FRU_LOCATION_SUFFIX = "-SPOT-LAN-CONNECTION";
                    } else if (gFailings.size() == countOfPartitions) {
                        Trace.trace(TRACE_MASKD, "mulitple hmcs with failures to multiple Partitions systems");
                        refcode = "B3030003";
                        FRU_PARTNUMBER = "PTNNTWK";
                        FRU_LOCATION_SUFFIX = "-SPOT-LAN-CONNECTION";
                    } else if (gFailings.size() == countOfConsoles) {
                        Trace.trace(TRACE_MASKD, "mulitple hmcs with failures to multiple console systems");
                        refcode = "B3030009";
                        FRU_PARTNUMBER = "HMCMULTNTWK";
                        FRU_LOCATION_SUFFIX = "-SPOT-LAN-CONNECTION";
                    } else {
                        Trace.trace(TRACE_MASKD, "mulitple hmcs with failures to multiple  systems");
                        refcode = "B3030007";
                        FRU_PARTNUMBER = "SYSNTWK";
                        FRU_LOCATION_SUFFIX = "-LAN-CONNECTIONS";
                    }
                }
                CommonProblem primeProblem = null;
                gsadapI = gsadPool.iterator();
                if (gsadapI.hasNext()) {
                    Trace.trace(TRACE_MASKD, "set prime problem with first on in pool");
                    CommonServiceIncident primIncident = (CommonServiceIncident)gsadapI.next();
                    primeProblem = (PIProblem)primIncident.getProblem();
                    if (refcode != null) {
                        primeProblem.setRefcode(refcode);
                    }
                    SupportingSurveillanceInfo ssi = new SupportingSurveillanceInfo();
                    this.setSupportingInfo(ssi, (PIProblem)primeProblem);
                    ((PIProblem)primeProblem).setSupportingSurvInfo(ssi);
                }
                symFru.setPartNumber(FRU_PARTNUMBER);
                symFru.addLocation(primeProblem.getFailingSystem().getMTMS() + FRU_LOCATION_SUFFIX);
                primeProblem.addPart(symFru);
                Trace.trace(TRACE_MASKD, "prime is set not loop throug remainder");
                ArrayList<CommonServiceIncident> removableIncidents = new ArrayList<CommonServiceIncident>();
                while (gsadapI.hasNext()) {
                    Trace.trace(TRACE_MASKD, "gsadPool has more than one incident add it ssi and add to removable List");
                    CommonServiceIncident supportIncident = (CommonServiceIncident)gsadapI.next();
                    PIProblem problem = (PIProblem)supportIncident.getProblem();
                    SupportingSurveillanceInfo ssi = new SupportingSurveillanceInfo();
                    this.setSupportingInfo(ssi, problem);
                    ((PIProblem)primeProblem).setSupportingSurvInfo(ssi);
                    removableIncidents.add(supportIncident);
                }
                Trace.trace(TRACE_MASKD, "removableIncidents.size()= " + removableIncidents.size());
                Iterator removeI = removableIncidents.iterator();
                while (removeI.hasNext()) {
                    Trace.trace(TRACE_MASKD, "removing from gsad pool");
                    gsadPool.remove((CommonServiceIncident)removeI.next());
                }
            } else {
                Trace.trace(TRACE_MASKD, "single hmc with failures let the LocalAnalysis problems flow");
            }
            gsadapI = gsadPool.iterator();
            StringBuffer sb = new StringBuffer();
            while (gsadapI.hasNext()) {
                cp = ((CommonServiceIncident)gsadapI.next()).getProblem();
                Trace.trace(TRACE_MASKD, "GSAD problem to open primaryAnalyzing= " + cp.getPrimaryAnalyzingConsoleSystem().getMTMS());
                Trace.trace(TRACE_MASKD, "GSAD problem to open reportingSystem= " + cp.getReportingRemoteMachineSystem().getMTMS());
                Trace.trace(TRACE_MASKD, "GSAD problem to open failingSystem= " + cp.getFailingSystem().getMTMS());
            }
            Trace.trace(TRACE_MASKD, "<-- GlobalSurveillance.analyze()");
        }
        Trace.trace(TRACE_MASKT, "<-- GlobalSurveillance.analyze()");
    }

    private HashMap getFailingSystems(HashMap hmcsAnalysis) {
        HashMap gFailings = new HashMap();
        Set hmcKeys = hmcsAnalysis.keySet();
        Iterator hkI = hmcKeys.iterator();
        boolean countOfFailingSystems = false;
        while (hkI.hasNext()) {
            String hmcMTMS = (String)hkI.next();
            HashMap failingSystems = (HashMap)hmcsAnalysis.get(hmcMTMS);
            Iterator fsKI = failingSystems.keySet().iterator();
            while (fsKI.hasNext()) {
                String fsKey = (String)fsKI.next();
                if (gFailings.containsKey(fsKey)) continue;
                gFailings.put(fsKey, failingSystems.get(fsKey));
            }
        }
        return gFailings;
    }

    protected void setSupportingInfo(SupportingSurveillanceInfo supportingInfo, PIProblem problem) {
        if (problem == null) {
            return;
        }
        if (problem.getReportingRemoteMachineSystem() != null) {
            supportingInfo.setEndPointA(problem.getReportingRemoteMachineSystem());
        }
        if (problem.getFailingSystem() != null) {
            supportingInfo.setEndPointB(problem.getFailingSystem());
        }
        if (problem.getRefcode() != null) {
            supportingInfo.setRefcode(problem.getRefcode());
        }
    }
}

